/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.region;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.region.VWConfigStepProcessorLocationTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class VWConfigStepProcessorLocationDialog
extends VWModalDialog
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
ActionListener {
    private static final int STATUS_NONE = 0;
    private static final int STATUS_OK = 1;
    private static final int STATUS_CANCELED = 2;
    private int m_nStatus = 0;
    private VWToolbarBorder m_toolBarBorder = null;
    private VWTable m_webServerTable = null;
    private VWConfigStepProcessorLocationTableModel m_tableModel = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;

    public VWConfigStepProcessorLocationDialog(Frame parent, VWSessionInfo sessionInfo, Hashtable locations) {
        super(parent);
        this.createControls(sessionInfo, locations);
        this.m_webServerTable.clearSelection();
        if (this.m_webServerTable.getRowCount() > 0) {
            this.m_webServerTable.setRowSelectionInterval(0, 0);
        }
    }

    public Hashtable getLocations() {
        this.stopTableEditing();
        if (this.m_tableModel != null) {
            return this.m_tableModel.getLocations();
        }
        return null;
    }

    public boolean isCanceled() {
        return this.m_nStatus == 2;
    }

    public boolean stopTableEditing() {
        if (this.m_webServerTable != null) {
            this.m_webServerTable.stopEditing();
        }
        return true;
    }

    public void releaseResources() {
        if (this.m_toolBarBorder != null) {
            this.m_toolBarBorder.releaseResources();
            this.m_toolBarBorder = null;
        }
        if (this.m_webServerTable != null) {
            this.m_webServerTable.removeAll();
            this.m_webServerTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton.removeAll();
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_webServerTable.getSelectedRow()) {
                    this.m_webServerTable.clearSelection();
                }
                this.m_webServerTable.setRowSelectionInterval(nRow, nRow);
                this.m_webServerTable.ensureRowIsVisible(nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nFirstIndex = this.m_webServerTable.getSelectionModel().getMinSelectionIndex();
            int nLastIndex = this.m_webServerTable.getSelectionModel().getMaxSelectionIndex();
            if (nFirstIndex < this.m_tableModel.getMinimumRowCount() || nLastIndex < this.m_tableModel.getMinimumRowCount()) {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 2, 0x10000000));
            } else {
                this.m_toolBarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolBarBorder.getClientPanel(), 1, 0x10000000));
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            switch (event.getID()) {
                case 16: {
                    this.stopTableEditing();
                    int nRow = this.m_tableModel.getRowCount();
                    this.m_tableModel.addRow();
                    this.m_webServerTable.setRowSelectionInterval(nRow, nRow);
                    this.m_webServerTable.setColumnSelectionInterval(0, 0);
                    this.m_webServerTable.ensureRowIsVisible(nRow);
                    break;
                }
                case 0x10000000: {
                    this.onDeleteRows();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_okButton)) {
            this.stopTableEditing();
            this.m_nStatus = 1;
            this.setVisible(false);
        } else if (source.equals(this.m_cancelButton)) {
            this.m_nStatus = 2;
            this.setVisible(false);
        } else if (source.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc072.htm");
        }
    }

    private void createControls(VWSessionInfo sessionInfo, Hashtable locations) {
        try {
            this.setTitle(VWResource.StepProcessorInfoLocationDlg);
            Dimension dim = VWStringUtils.stringToDimension("495,335");
            if (dim == null) {
                dim = new Dimension(450, 175);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.getMainPanel(sessionInfo, locations), "Center");
            this.getContentPane().add((Component)this.getButtonPanel(), "Last");
            this.setLocationRelativeTo(this.getParent());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getMainPanel(VWSessionInfo sessionInfo, Hashtable locations) {
        try {
            this.m_toolBarBorder = new VWToolbarBorder(VWResource.EnterTheWebPageInfo, 0x10000010);
            this.m_toolBarBorder.addToolbarBorderActionNotifier(this);
            this.m_tableModel = new VWConfigStepProcessorLocationTableModel(this, locations);
            this.m_tableModel.addTableModelListener(this);
            this.m_webServerTable = new VWTable(this.m_tableModel);
            this.m_webServerTable.setRowSelectionAllowed(true);
            this.m_webServerTable.getSelectionModel().addListSelectionListener(this);
            this.m_webServerTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_webServerTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            JPanel panel = this.m_toolBarBorder.getClientPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JScrollPane(this.m_webServerTable), "Center");
            JPanel mainPanel = new JPanel(new BorderLayout(4, 4));
            mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            mainPanel.add((Component)this.m_toolBarBorder, "Center");
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.addActionListener(this);
            buttonPanel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            buttonPanel.add(this.m_helpButton);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void onDeleteRows() {
        try {
            this.stopTableEditing();
            int[] rows = this.m_webServerTable.getSelectedRows();
            for (int nIndex = rows.length - 1; nIndex >= 0; --nIndex) {
                this.m_tableModel.removeRow(rows[nIndex]);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

